'use strict'
//创建angularjs app module
if (!window.appModule) {
    window.appModule = angular.module('appModule', ['ngSanitize', 'ngAnimate', 'pascalprecht.translate']);
}
//记录Angular的错误
appModule.factory('$exceptionHandler', ['log', function (log) {
    return function (e, cause) {
        log.logError('app encounters an unexpected error :' + e.stack);
    };
}]);

//隐藏鼠标右键菜单
document.oncontextmenu = function () {
    return false;
};

//处理拖动外部图片到界面后导致CEF只显示图片的问题
document.ondragover = function (e) {
    e.preventDefault();
};

//处理拖动外部图片到界面后导致CEF只显示图片的问题
document.ondrop = function (e) {
    e.preventDefault();
};

document.onkeydown = function (e) { //阻止CEF 默认回退键执行 返回 操作
    if (e.keyCode == 8 && e.target.tagName.toLowerCase() != "input" && e.target.tagName.toLowerCase() != "textarea" && !e.target.getAttribute('contenteditable')) {
        e.preventDefault();
    }
};

var languagePromise = (function ($) {
    var defer = $.Deferred();
    var currentLanguage = ucClient.ClientService.getLanguage();
    appModule.lang = currentLanguage == 1033?'en-us':'zh-cn';
    var languageFile='nls/'+appModule.lang + '.json';
    $.getJSON(languageFile, function (data) {
        var dataString = JSON.stringify(data);
        dataString = dataString.replace(/i广播/g, localStorage.noticeAppName);
        data = JSON.parse(dataString);
        defer.resolve(data);
    });
    return defer.promise();
})(jQuery);

//加载语言文件，引导angularjs
angular.element(document).ready(function () {
    languagePromise.then(function (data) {
        window.appModule.config(['$translateProvider', function ($translateProvider) {
            $translateProvider.translations('zh', data);
            $translateProvider.preferredLanguage('zh');
        }]);
        angular.bootstrap(document, ['appModule']);
    });
});

ucClient.addEventListener("ClosePublishWindows", function () {
    if (window.top !== window) {
        return;
    }
    ucClient.Window.close();
});